#ifndef __SOCKET_H_
#define __SOCKET_H_

namespace CPPMUD
{
	#ifdef _WIN32
	// Windows
	#if _MSC_VER > 1000
	#pragma once
	#endif

	#include <winsock2.h>
	#else
	// *NIX
	#include <errno.h>
	#include <fcntl.h>
	#include <signal.h>
	#include <unistd.h>
	#include <sys/types.h>
	#include <sys/socket.h>
	#include <sys/wait.h>
	#include <netinet/in.h>
	#include <netdb.h>
	#endif

	class CClientDescriptor
	{
		friend class CBSDSocket;
		friend class CServerSocket;
		friend class CWinSocket;

	public:
		// Constructor & Deconstructor
		CClientDescriptor();
		~CClientDescriptor();

		// Public Accessor Functions
		const bool IsInputPending() { return m_bInputPending; }
		const char *GetInputBuffer() { return m_czIncomingData; }
		const ConnState GetConnState() { return m_csState; }
		const int GetClientID() { return m_nClientID; }
		const int GetLineFromInputBuffer(char *czOutput, int nMaxLength);
		const SOCKET GetSocket() { return m_sSocket; }
		const void SetConnState(ConnState csState) { m_csState = csState; }

		// Public Functions

		// Public Variables

	protected:
		// Protected Functions

		// Protected Variables
		bool m_bInputPending;
		char m_czIncomingData[2048];
		char m_czOutgoingData[2048];
		ConnState m_csState;
		int m_nClientID;
		sockaddr_in m_saClientInf;
		SOCKET m_sSocket;
	};

	class CServerSocket
	{
	public:
		// Constructor & Deconstructor
		CServerSocket();
		virtual ~CServerSocket();

		// Public Accessor Functions
		const int GetMaxClients() { return m_nMaxClients; }
		const int GetNumClients() { return m_vecClients.size(); }
		void SetMaxClients(int nMaxClients) { m_nMaxClients = nMaxClients; }

		// Public Functions
		ErrRet CheckForNewData();
		ErrRet SendData(char *czData, int nBufferSize, int nClientID);
		virtual ErrRet CloseClient(int nClientID) = 0;
		virtual ErrRet CloseSockets() = 0;
		virtual ErrRet Connect(int nPort) = 0;
		virtual ErrRet InitSockets() = 0;
		virtual ErrRet Listen(int nPort) = 0;
		virtual ErrRet ReadData(char *czData, int nBufferSize, int nClientID) = 0;
		virtual void NonBlocking(SOCKET sSocket) = 0;

		// Public Variables
		std::vector<CClientDescriptor> m_vecClients;

	protected:
		// Protected Functions
		ErrRet NewClient();
		int GetIndexFromClientID(int nClientID);
		virtual ErrRet CloseSocket(SOCKET sSocket) = 0;
		virtual ErrRet SendData(int nClientID) = 0;

		// Protected Variables
		int m_nMaxClients;
		int m_nNextClientID;
		sockaddr_in m_saAddress;
		SOCKET m_sSocket;
	};
};

#endif
